
!"Pocket Smalltalk fileout - 2003N68-15:26:47"!


!Object constantsFor: 'PalmOS Fonts'!

boldFont 1! 
largeBoldFont 7! 
largeFont 2! 
ledFont 6! 
stdFont 0! 
symbol11Font 4! 
symbol7Font 5! 
symbolFont 3! !

!Object methodsFor: 'utility'!

debugTrace: aString
	| ptr |

	ptr := SYSTRAP MemPtrNew: 100.
	aString copyToHeap: ptr.
	self primDebugTrace: ptr.
	SYSTRAP MemChunkFree: ptr.
! !


!Object methodsFor: 'utility'!

primDebugTrace: aString
	<primitive: 104>
	^self primitiveFailed.
! !


!Integer methodsFor: 'undefined'!

asByteArray
	| b |
	
	b := String new: 4.
	b at: 4 put: (Character value: (self bitAnd: 255)).
	b at: 3 put: (Character value: ((self bitShift: -8) bitAnd: 255)).
	b at: 2 put: (Character value: ((self bitShift: -16) bitAnd: 255)).
	b at: 1 put: (Character value: ((self bitShift: -24) bitAnd: 255)).
	^b.	
! !


!String methodsFor: 'comparing'!

startsWith: compare
	| a b |

	self size >= compare size ifFalse: [ ^false. ].
	
	1 to: compare size do: [ :i | a := (self at: i) asInteger.
			b := (compare at: i) asInteger.
			a = b ifFalse: [ ^false. ]. 
	].				
		
	^true.
! !


!String methodsFor: 'comparing'!

trimBlanks
	^self withoutTrailingBlanks withoutLeadingBlanks.
! !


!String methodsFor: 'comparing'!

withoutTrailingBlanks
	self isEmpty ifTrue: [ ^self. ].
	self last isWhitespace ifFalse: [ ^self. ].
	
	self size to: 1 by: -1 do: [ : i |
		(self at: i) isWhitespace ifFalse: [
			^self copyFrom: 1 to: i.
		].
	].
	^''.
! !


!String methodsFor: 'comparing'!

withoutLeadingBlanks
	self isEmpty ifTrue: [ ^self. ].
	self first isWhitespace ifFalse: [ ^self. ].
	
	1 to: self size do: [ : i |
		(self at: i) isWhitespace ifFalse: [
			^self copyFrom: i to: self size.
		].
	].
	^''.
! !


!String methodsFor: 'comparing'!

= string
	| a b |

	self size = string size ifFalse: [ ^false. ].
	
	1 to: self size do: [ :i | a := (self at: i) asInteger.
			b := (string at: i) asInteger.
			a = b ifFalse: [ ^false. ]. 
	].				
		
	^true
! !


!String methodsFor: 'comparing'!

< string
	"BJH"
	| min a b |
	
	min := (self size) min: (string size).
	
	1 to: min do: [ :i | a := (self at: i) asInteger.
			b := (string at: i) asInteger.
			a < b 
				ifTrue: [ ^true ]
				ifFalse: [ b < a
						ifTrue: [ ^false ] ] ].
				
	(self size) < (string size)
		ifTrue: [ ^true ].
		
	^false! !


